<?php
/* --------------------------------------------------------------
   UsermodJSMaster.inc.php 2020-03-04
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2018 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

class UsermodJSMaster
{
    public $v_page = '';

    public function __construct($p_page = 'Global')
    {
        $this->set_page($p_page);
    }


    public function set_page($p_page)
    {
        $this->v_page = basename($p_page);
    }


    public function get_page()
    {
        return $this->v_page;
    }
    
    
    /**
     * @param string $theme_id
     * @param string $group
     * @param array  $gxThemeFiles
     *
     * @return array
     */
    protected function get_theme_files(string $theme_id, string $group, array $gxThemeFiles){
        $t_files_array = [];
        //page scripts
        if(isset($gxThemeFiles[$theme_id][$group]['javascript'][strtolower($this->get_page())])){
            foreach ($gxThemeFiles[$theme_id][$group]['javascript'][strtolower($this->get_page())] as $file) {
                $t_files_array[] = $file;
            }
        }
        
        return $t_files_array;
    
    }
    
    
    public function get_files()
    {
        $dataCache = DataCache::get_instance();
        $cacheKey  = 'js_usermods-' . StaticGXCoreLoader::getThemeControl()->getCurrentTheme() . '-'. $this->get_page();
        
        if ($dataCache->key_exists($cacheKey, true)) {
            return $dataCache->get_data($cacheKey, true);
        }
        
        $t_files_array = [];
        
        if (StaticGXCoreLoader::getThemeControl()->isThemeSystemActive()) {
            $includedFiles = [];
            $gxThemeFiles  = GXModulesCache::getInstalledThemeFiles();
            $themes        = array_reverse(StaticGXCoreLoader::getThemeControl()->getCurrentThemeHierarchy());
            $themes        = array_merge(['all'], array_map('strtolower', $themes));
            
            foreach ($themes as $currentTheme) {
                $includedFiles[] = $this->get_theme_files($currentTheme, 'core', $gxThemeFiles);
            }
            foreach ($themes as $currentTheme) {
                $includedFiles[] = $this->get_theme_files($currentTheme, 'custom', $gxThemeFiles);
            }
            $t_files_array = array_merge(...$includedFiles);
            $t_files_array = array_unique($t_files_array);
        } else {
            
            $t_coo_cached_directory = new CachedDirectory(DIR_FS_CATALOG .
                                                          StaticGXCoreLoader::getThemeControl()->getThemePath()
                                                          . 'usermod/javascript/Global'
            );
            
            while (false !== ($t_entry = $t_coo_cached_directory->read())) {
                if ($t_entry[0] !== '.' && substr($t_entry, -3) === '.js') {
                    $t_files_array[] = DIR_FS_CATALOG . StaticGXCoreLoader::getThemeControl()->getThemePath()
                                       . 'usermod/javascript/Global/' . basename($t_entry);
                }
            }
            
            if ($this->get_page() !== 'Global') {
                $t_coo_cached_directory->set_path(DIR_FS_CATALOG . StaticGXCoreLoader::getThemeControl()->getThemePath()
                                                  . 'usermod/javascript/' . $this->get_page());
                
                while (false !== ($t_entry = $t_coo_cached_directory->read())) {
                    if ($t_entry[0] !== '.' && substr($t_entry, -3) === '.js') {
                        $t_files_array[] = DIR_FS_CATALOG . StaticGXCoreLoader::getThemeControl()->getThemePath()
                                           . 'usermod/javascript/' . $this->get_page() . '/' . basename($t_entry);
                    }
                }
            }
            
            $gxModuleFiles = GXModulesCache::getInstalledModuleFiles();
            $directoryName = StaticGXCoreLoader::getThemeControl()->isThemeSystemActive() ? 'Themes' : 'Templates';
            $addedJsFiles  = [];
            foreach (array_reverse(StaticGXCoreLoader::getThemeControl()
                                                     ->getCurrentThemeHierarchy()) as $currentTheme) {
                foreach ($gxModuleFiles as $file) {
                    if (substr($file, -3) === '.js' && !in_array($file, $addedJsFiles)
                        && (stripos($file,
                                    '/' . $directoryName . '/' . $currentTheme . '/Javascript/' . $this->get_page()
                                    . '/') !== false
                            || stripos($file, '/' . $directoryName . '/All/Javascript/' . $this->get_page() . '/')
                               !== false)) {
                        $t_files_array[] = $file;
                        $addedJsFiles[]  = $file;
                    }
                }
            }
        }
        
        $dataCache->set_data($cacheKey, $t_files_array, true);
        
        return $t_files_array;
    }
}
